I am trying to learn how to use Salvo Lite because I am trying to teach myself
how to use an RTOS.  I reviewed many free RTOS's and settled upon trying Salvo.
Mainly because it had a version for QuadraVOX tools, which I own.

I have previously used only QuadraVOX and the MSP430 for
several projects.  I am doing this on my own and I have an idea that if I get 
working, then I would like to share to help others get started.

I am including sample code below.  I am trying to do something extremely
limited to get started.  I simply want to print some characters using the 
serial port on my PC and HyperTERM.

I cannot get it working and it constantly repeats without finishing the
line of text I want to print.  My uncertainty is that I could not find out
how I properly should setup the UART for use with Salvo.  I tried using code 
I had previously written, for the setup (19,200 bps).

If someone could guide me on how to do this simple writing to the UART, that
would be greatly appreciated.  I am soley doing this as a learning experience, 
and will gladly share my completed idea when it is ready.

#include "main.h"
#include "salvo.h"
#include "RTOS_Serial.h"

#define TASK1_P			OSTCBP(1)
#define TASK2_P			OSTCBP(2)
#define TASK3_P			OSTCBP(3)
#define BINSEM1_P		OSECBP(1)
#define BINSEM2_P		OSECBP(2)
#define SEM_CARH		OSECSP(3)
#define REC_CHAR		OSECSP(4)
/* Global variables	*/

/* Serial Port Memory 									*/
unsigned char receive_counter=0,current_counter=0,wdt_int_count;
unsigned char receive_buffer[32],PC_Command;
unsigned char login=FALSE,permission=FALSE;
/*Serial  Port Prompt									*/
unsigned char PS1[16]="MSP430F149",startup=TRU;
unsigned password_entry=FALSE;

/* use OSLabel() to create context-switching labels		*/
_OSLabel(Task1a)

/*Task 1*/
void SerialPortData(void)
{	
	for(;;)
	{
		if(startup)
		{
			CommandPrintStartupMessage();
			startup = FALSE;
		}
		OS_Yield();
	}
}
void main (void)
{
	unsigned char priority0=0,priority1=3,priority2=5,priority3=7;
	
	InitPORT();
	
	Init();
	
	FlashPortSetup();

	UARTInit();
	
	/* Initialize Salvo									*/
	OSInit();
	
	/* create tasks										*/
	OSCreateTask(GetSerialPortData, TASK1_P, priority1);
	/* enable interrupts								*/
	OSEi();
	
	/* start multitasking								*/
	for(;;)
		OSSched();
		
}
//-------------------------------

/*****************************************************
*                                                    *
*			CommandPrintStartupMessage     	 	 	 *
*                                                    *
******************************************************/	
void CommandPrintStartupMessage(void)
{

	while((IFG1 & UTXIFG0) == 0);
			WriteUARTData(0x0d);
	while((IFG1 & UTXIFG0) == 0);
			WriteUARTData(0x0a);

	while((IFG1 & UTXIFG0) == 0);
		WriteUARTData('R');
	while((IFG1 & UTXIFG0) == 0);
		WriteUARTData('o');
	while((IFG1 & UTXIFG0) == 0);
		WriteUARTData('b');
	while((IFG1 & UTXIFG0) == 0);
		WriteUARTData('"');
	while((IFG1 & UTXIFG0) == 0);
		WriteUARTData('s');
	while((IFG1 & UTXIFG0) == 0);
		WriteUARTData(' ');
	while((IFG1 & UTXIFG0) == 0);
		WriteUARTData('T');
	while((IFG1 & UTXIFG0) == 0);
		WriteUARTData('E');
	while((IFG1 & UTXIFG0) == 0);
		WriteUARTData('S');
	while((IFG1 & UTXIFG0) == 0);
		WriteUARTData('T');
	while((IFG1 & UTXIFG0) == 0);
		WriteUARTData('!');
	
	while((IFG1 & UTXIFG0) == 0);
		WriteUARTData(0x0d);
	while((IFG1 & UTXIFG0) == 0);
		WriteUARTData(0x0a);
}
//-------------------------------

/*****************************************************
*                                                    *
*                  WriteUARTData                     *
*                                                    *
******************************************************/
unsigned char WriteUARTData(unsigned char data_byte)
{
	
	TXBUF0 = data_byte;
	return 0;
}

/*****************************************************
*                                                    *
*                  UARTInit                          *
*                                                    *
******************************************************/
void UARTInit(void)
{
	//BCSCTL2 &= ~DIVS0;			//Divide SMCLK by 1.  Turn off below
	//BCSCTL2 &= ~DIVS1;
	BCSCTL2 &= ~(DIVS0 | DIVS1);
	P3OUT |= BIT2;
	P2OUT &= ~BIT7;
	_BIC_SR(SCG1);			// Enable SMCLK
	UCTL0 = CHAR;			// 8-bit character
	//UTCTL0 |= SSEL0;		// UCLK = SMCLK
	//UTCTL0 |= SSEL1;		// 0 = UCLK, 1 = ACLK, 2,3 = SMCLK
	UTCTL0 |= (SSEL0 | SSEL1);
	//UBR00 = 0xBA;			// Baudrate = BRCLK / UxBR = 3.58MHz / 19,200 = 186.46 = 0xBA
	UBR00 = 0xC0;			// Baudrate = BRCLK / UxBR = 3.58MHz / 19,200 = 186.46 = 0xBA
	UBR10 = 0x00;			//
	UMCTL0 = 0x00;			// No Modulation
	ME1 |= UTXE0 + URXE0;	// Enable USART0 TXD/RXD
	IE1 |= URXIE0;			// Enable USART0 RX Interrupt
	P3SEL |= 0x30;			// P3.4,5 = USART TXD/RXD
}
//-------------------------------
/*****************************************************
*                                                    *
*                 FlashPortSetup                     *
*                                                    *
******************************************************/
void FlashPortSetup(void)
{

/*
	BCSCTL1 &= ~XTS;			// Low frequency crystal selected
	BCSCTL1 &= ~XT5V;			// Should always be reset
	BCSCTL1 &= ~XT2OFF;			// High Frequency Crystal for X2
	BCSCTL1 |= DIVA0;			// 0=/1, 1=/2, 2=/4, 3=/8
	BCSCTL1 |= DIVA1;			// ACLK = 32K / 8 = 4096
*/
	BCSCTL1 = DIVA0 + DIVA1;
	DCOCTL &= 0;
	/*
	BCSCTL2 &= ~SELM0;			// MCLK Selection 0, 1 = DCOCLK
	BCSCTL2 |= SELM1;			// 2 = XT2CLK, 3 = LFXT1CLK
	BCSCTL2 |= SELS;			// Sub System Clock = XT2CLK
	BCSCTL2 &= ~DIVM0;			// Divide MCLK by 1
	BCSCTL2 &= ~DIVM1;
	BCSCTL2 &= ~DIVS0;			//Divide SMCLK by 1.  Turn off below
	BCSCTL2 &= ~DIVS1;
	*/
	BCSCTL2 = SELM1 + SELS;
	IFG1 &= ~OFIFG;				// Clear OSCFault Flag
	_BIS_SR(SCG1);				//Disable SMCLK used for UART
	_BIS_SR(SCG0);				//Disable DCO
	
    //set up interrupt for RTC
    //Reduce insctructions by loading one word into register
    /*
    TBCTL &= ~MC0;					//0,1 Count Up to CCR0					
    TBCTL |= MC1;					//1,0 Continous
    TBCTL |= TBSSEL0;				//0,1 = ACLK(32,768Hz)
    TBCTL &= ~TBSSEL1;
    TBCTL &= ~ID0;					//0 = input source passed to timer (/1)					
    TBCTL &= ~ID1;
    TBCTL |= CNTL0;					//0 = 16 bit counter, 1 = 12 bit counter
    TBCTL &= ~CNTL1;
    TBCTL |= TBCLR; 
    TBCTL |= TBIE;
    */
    //TBCTL = MC1 + TBSSEL0 + CNTL0 + TBCLR + TBIE;
//****************PORT SETUP**************************    
    P1OUT = 0;
    P1DIR = 0xCA;				//0y11001010 = 0xCA
    P1SEL = 0;
        						
    P2OUT = 0x80;				//0y10000000
    P2DIR = 0xB4;				//Key Inputs = 0y10110100 = 0xB4
    //P2DIR = 0x94;				//Key Inputs = 0y10010100 = 0xB4 Due to short on oard from IrDA test
    P2SEL = 0x00;				//P2.5 output high incase Rosc installed,0y10011100 = 0xAC
          
    P3OUT = 0xC2;				//0y11000000
    P3DIR = 0x57;         		//0y01010111= 0x57
 	P3SEL = 0x00;				//SET UP FOR UART 
                  
    P4OUT = 0xFF;				//
    P4DIR = 0xFF;
    P4SEL = 0;
          
    P5OUT = 0xFF;
    P5DIR = 0xFF;
    //P5SEL = 0x60;				//0y0110 0000 = 0x60
    P5SEL = 0;
	P6DIR = 0x78;				//0y01111000
	P6SEL = 0x87;				//ADC A7 for VBAT, A2 for Temp, A0 for measurement A1 FERTILITY
    							// = 0y10000111 = 0x87    
}